import os

directory = "/osc-fs_home/mdehoon/Data/CASPARs/MiSeq/Fastq/"
suffix = "_READ1.fq.gz"
output = open("script.sh", 'w')
counter = 0
filenames = sorted(os.listdir(directory))
for filename in filenames:
    if not filename.endswith(suffix):
        continue
    basename = filename[:-len(suffix)]
    script_name = "script_%s.sh" % basename
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#SBATCH -e ./script_%s.stderr
#SBATCH -o ./script_%s.stdout
#SBATCH --mem=16G
python mergebam.py %s
""" % (basename, basename, basename))
    handle.close()
    output.write('sbatch %s\n' % script_name)
    counter += 1
output.close()
print("%d scripts generated; run script.sh to schedule them on Grid Engine" % counter)
